/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.model;

import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.IndexUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.js.core.model.BaseElement;
import com.aptana.js.core.model.IHasPredefinedValues;
import com.aptana.js.core.model.ReturnTypeElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyElement
extends BaseElement
implements IHasPredefinedValues {
    private static final String EXAMPLES_PROPERTY = "examples";
    private static final String TYPES_PROPERTY = "types";
    private static final String IS_INTERNAL_PROPERTY = "isInternal";
    private static final String IS_INSTANCE_PROPERTY = "isInstanceProperty";
    private static final String IS_CLASS_PROPERTY = "isClassProperty";
    private static final String OWNING_TYPE_PROPERTY = "owningType";
    private String _owningType;
    private boolean _isInstanceProperty;
    private boolean _isClassProperty;
    private boolean _isInternal;
    private List<ReturnTypeElement> _types;
    private List<String> _examples;
    private List<String> _constants;

    public PropertyElement() {
    }

    public PropertyElement(PropertyElement base) {
        this._owningType = base.getOwningType();
        this._isInstanceProperty = base.isInstanceProperty();
        this._isClassProperty = base.isClassProperty();
        this._isInternal = base.isInternal();
        this._types = new ArrayList<ReturnTypeElement>(base.getTypes());
        this._examples = new ArrayList<String>(base.getExamples());
        this._constants = new ArrayList<String>(base.getConstants());
    }

    public void addExample(String example) {
        if (example != null && example.length() > 0) {
            if (this._examples == null) {
                this._examples = new ArrayList<String>();
            }
            this._examples.add(example);
        }
    }

    public void addType(ReturnTypeElement type) {
        if (type != null) {
            int index;
            if (this._types == null) {
                this._types = new ArrayList<ReturnTypeElement>();
            }
            if ((index = this._types.indexOf(type)) != -1) {
                this._types.set(index, type);
            } else {
                this._types.add(type);
            }
        }
    }

    public void addType(String type) {
        if (type != null && type.length() > 0) {
            ReturnTypeElement returnType = new ReturnTypeElement();
            returnType.setType(type);
            this.addType(returnType);
        }
    }

    public int hashCode() {
        return this.toSource().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PropertyElement) {
            return ObjectUtil.areEqual((Object)this.toSource(), (Object)((PropertyElement)obj).toSource());
        }
        return super.equals(obj);
    }

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        this.setOwningType(StringUtil.getStringValue(object.get(OWNING_TYPE_PROPERTY)));
        this.setIsClassProperty(Boolean.TRUE == object.get(IS_CLASS_PROPERTY));
        this.setIsInstanceProperty(Boolean.TRUE == object.get(IS_INSTANCE_PROPERTY));
        this.setIsInternal(Boolean.TRUE == object.get(IS_INTERNAL_PROPERTY));
        this._types = IndexUtil.createList(object.get(TYPES_PROPERTY), ReturnTypeElement.class);
        this._examples = IndexUtil.createList(object.get(EXAMPLES_PROPERTY));
        this._constants = IndexUtil.createList(object.get("constants"));
    }

    public List<String> getExamples() {
        return CollectionsUtil.getListValue(this._examples);
    }

    @Override
    public List<String> getConstants() {
        return CollectionsUtil.getListValue(this._constants);
    }

    public String getOwningType() {
        return StringUtil.getStringValue((Object)this._owningType);
    }

    public List<String> getTypeNames() {
        return CollectionsUtil.map(this.getTypes(), (IMap)new IMap<ReturnTypeElement, String>(){

            public String map(ReturnTypeElement item) {
                return item.getType();
            }
        });
    }

    public List<ReturnTypeElement> getTypes() {
        return CollectionsUtil.getListValue(this._types);
    }

    public boolean isClassProperty() {
        return this._isClassProperty;
    }

    public boolean isInstanceProperty() {
        return this._isInstanceProperty;
    }

    public boolean isInternal() {
        return this._isInternal;
    }

    public void setIsClassProperty(boolean value) {
        this._isClassProperty = value;
    }

    public void setIsInstanceProperty(boolean value) {
        this._isInstanceProperty = value;
    }

    public void setIsInternal(boolean value) {
        this._isInternal = value;
    }

    public void setOwningType(String type) {
        this._owningType = type;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(OWNING_TYPE_PROPERTY, (Object)this.getOwningType());
        out.add(IS_CLASS_PROPERTY, this.isClassProperty());
        out.add(IS_INSTANCE_PROPERTY, this.isInstanceProperty());
        out.add(IS_INTERNAL_PROPERTY, this.isInternal());
        out.add(TYPES_PROPERTY, this.getTypes());
        out.add(EXAMPLES_PROPERTY, this.getExamples());
        out.add("constants", this.getConstants());
    }

    @Override
    public void toSource(SourcePrinter printer) {
        printer.printIndent();
        if (this.isClassProperty()) {
            printer.print("static ");
        }
        if (this.isInternal()) {
            printer.print("internal ");
        }
        printer.print(this.getName());
        printer.print(" : ");
        List<String> types = this.getTypeNames();
        if (types != null && types.size() > 0) {
            printer.print(StringUtil.join((String)",", this.getTypeNames()));
        } else {
            printer.print("undefined");
        }
    }

    public String toString() {
        return this.toSource();
    }
}

